<?php

    use Illuminate\Database\Migrations\Migration;
    use Illuminate\Database\Schema\Blueprint;
    use Illuminate\Support\Facades\Schema;

    class CreateSupportAgentsTable extends Migration
    {
        public function up(): void
        {
            Schema::create('support_agents', function (Blueprint $table) {
                $table->id();
                $table->uuid()->unique();
                $table->unsignedBigInteger('user_id')->unique(); // Link to users table
                $table->string('designation')->nullable();       // Optional: "Support Executive"
                $table->text('bio')->nullable();                 // Short description/bio
                $table->boolean('is_active')->default(true);     // Status
                $table->timestamps();

                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            });
        }

        public function down(): void
        {
            Schema::dropIfExists('support_agents');
        }
    }
