<?php

    use Illuminate\Database\Migrations\Migration;
    use Illuminate\Database\Schema\Blueprint;
    use Illuminate\Support\Facades\Schema;

    return new class extends Migration {

        public function up(): void
        {
            Schema::create('support_ticket_messages', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('ticket_id');
                $table->unsignedBigInteger('user_id');
                $table->text('message');
                $table->boolean('is_internal')->default(false); // Internal notes
                $table->timestamps();

                $table->foreign('ticket_id')->references('id')->on('support_tickets')->onDelete('cascade');
                $table->foreign('user_id')->references('id')->on('users');
            });
        }

        public function down(): void
        {
            Schema::dropIfExists('support_ticket_messages');
        }

    };
