<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Logging;

use PaypalServerSdkLib\ConfigurationDefaults;
use Core\Logger\Configuration\LoggingConfiguration;
use Core\Logger\ConsoleLogger;
use Core\Utils\CoreHelper;
use Psr\Log\InvalidArgumentException;
use Psr\Log\LoggerInterface;

class LoggingConfigurationBuilder
{
    /**
     * @var LoggerInterface|null
     */
    private $logger;
    private $level = ConfigurationDefaults::LOGGER_LEVEL;
    private $maskSensitiveHeaders = ConfigurationDefaults::LOGGER_MASK_SENSITIVE_HEADERS;
    private $requestConfig;
    private $responseConfig;

    private function __construct()
    {
        $this->logger = new ConsoleLogger('printf');
        $this->requestConfig = RequestLoggingConfigurationBuilder::init();
        $this->responseConfig = ResponseLoggingConfigurationBuilder::init();
    }

    /**
     * Initializer for LoggingConfigurationBuilder.
     */
    public static function init(): self
    {
        return new self();
    }

    public function logger(LoggerInterface $logger): self
    {
        $this->logger = $logger;
        return $this;
    }

    /**
     * Setter for level of logging. See Psr\Log\LogLevel.php for possible values of log levels.
     *
     * @param string $level
     *
     * @return $this
     */
    public function level(string $level): self
    {
        if (!in_array($level, ConfigurationDefaults::LOGGER_ALLOWED_LEVELS, true)) {
            throw new InvalidArgumentException(
                'Invalid LogLevel. See Psr\Log\LogLevel.php for possible values of log levels.'
            );
        }
        $this->level = $level;
        return $this;
    }

    public function maskSensitiveHeaders(bool $maskSensitiveHeaders): self
    {
        $this->maskSensitiveHeaders = $maskSensitiveHeaders;
        return $this;
    }

    public function requestConfiguration(RequestLoggingConfigurationBuilder $requestConfig): self
    {
        $this->requestConfig = $requestConfig;
        return $this;
    }

    public function responseConfiguration(ResponseLoggingConfigurationBuilder $responseConfig): self
    {
        $this->responseConfig = $responseConfig;
        return $this;
    }

    public function getConfiguration(): array
    {
        return [
            'logger' => CoreHelper::clone($this->logger),
            'level' => $this->level,
            'maskSensitiveHeaders' => $this->maskSensitiveHeaders,
            'requestConfiguration' => $this->requestConfig->getConfiguration(),
            'responseConfiguration' => $this->responseConfig->getConfiguration()
        ];
    }

    public function build(): LoggingConfiguration
    {
        return new LoggingConfiguration(
            $this->logger,
            $this->level,
            $this->maskSensitiveHeaders,
            $this->requestConfig->build(),
            $this->responseConfig->build()
        );
    }
}
