<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * A resource representing a response for Apple Pay.
 */
class ApplePayPaymentToken implements \JsonSerializable
{
    /**
     * @var ApplePayCard|null
     */
    private $card;

    /**
     * Returns Card.
     * The payment card to be used to fund a payment. Can be a credit or debit card.
     */
    public function getCard(): ?ApplePayCard
    {
        return $this->card;
    }

    /**
     * Sets Card.
     * The payment card to be used to fund a payment. Can be a credit or debit card.
     *
     * @maps card
     */
    public function setCard(?ApplePayCard $card): void
    {
        $this->card = $card;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->card)) {
            $json['card'] = $this->card;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
