<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * Information used to pay using BLIK level_0 flow.
 */
class BlikLevel0PaymentObject implements \JsonSerializable
{
    /**
     * @var string
     */
    private $authCode;

    /**
     * @param string $authCode
     */
    public function __construct(string $authCode)
    {
        $this->authCode = $authCode;
    }

    /**
     * Returns Auth Code.
     * The 6-digit code used to authenticate a consumer within BLIK.
     */
    public function getAuthCode(): string
    {
        return $this->authCode;
    }

    /**
     * Sets Auth Code.
     * The 6-digit code used to authenticate a consumer within BLIK.
     *
     * @required
     * @maps auth_code
     */
    public function setAuthCode(string $authCode): void
    {
        $this->authCode = $authCode;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['auth_code'] = $this->authCode;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
