<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CapturedPayment;
use PaypalServerSdkLib\Models\CaptureStatusDetails;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\NetworkTransactionReference;
use PaypalServerSdkLib\Models\Payee;
use PaypalServerSdkLib\Models\PaymentSupplementaryData;
use PaypalServerSdkLib\Models\ProcessorResponse;
use PaypalServerSdkLib\Models\SellerProtection;
use PaypalServerSdkLib\Models\SellerReceivableBreakdown;

/**
 * Builder for model CapturedPayment
 *
 * @see CapturedPayment
 */
class CapturedPaymentBuilder
{
    /**
     * @var CapturedPayment
     */
    private $instance;

    private function __construct(CapturedPayment $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new captured payment Builder object.
     */
    public static function init(): self
    {
        return new self(new CapturedPayment());
    }

    /**
     * Sets status field.
     */
    public function status(?string $value): self
    {
        $this->instance->setStatus($value);
        return $this;
    }

    /**
     * Sets status details field.
     */
    public function statusDetails(?CaptureStatusDetails $value): self
    {
        $this->instance->setStatusDetails($value);
        return $this;
    }

    /**
     * Sets id field.
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets amount field.
     */
    public function amount(?Money $value): self
    {
        $this->instance->setAmount($value);
        return $this;
    }

    /**
     * Sets invoice id field.
     */
    public function invoiceId(?string $value): self
    {
        $this->instance->setInvoiceId($value);
        return $this;
    }

    /**
     * Sets custom id field.
     */
    public function customId(?string $value): self
    {
        $this->instance->setCustomId($value);
        return $this;
    }

    /**
     * Sets network transaction reference field.
     */
    public function networkTransactionReference(?NetworkTransactionReference $value): self
    {
        $this->instance->setNetworkTransactionReference($value);
        return $this;
    }

    /**
     * Sets seller protection field.
     */
    public function sellerProtection(?SellerProtection $value): self
    {
        $this->instance->setSellerProtection($value);
        return $this;
    }

    /**
     * Sets final capture field.
     */
    public function finalCapture(?bool $value): self
    {
        $this->instance->setFinalCapture($value);
        return $this;
    }

    /**
     * Sets seller receivable breakdown field.
     */
    public function sellerReceivableBreakdown(?SellerReceivableBreakdown $value): self
    {
        $this->instance->setSellerReceivableBreakdown($value);
        return $this;
    }

    /**
     * Sets disbursement mode field.
     */
    public function disbursementMode(?string $value): self
    {
        $this->instance->setDisbursementMode($value);
        return $this;
    }

    /**
     * Sets links field.
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Sets processor response field.
     */
    public function processorResponse(?ProcessorResponse $value): self
    {
        $this->instance->setProcessorResponse($value);
        return $this;
    }

    /**
     * Sets create time field.
     */
    public function createTime(?string $value): self
    {
        $this->instance->setCreateTime($value);
        return $this;
    }

    /**
     * Sets update time field.
     */
    public function updateTime(?string $value): self
    {
        $this->instance->setUpdateTime($value);
        return $this;
    }

    /**
     * Sets supplementary data field.
     */
    public function supplementaryData(?PaymentSupplementaryData $value): self
    {
        $this->instance->setSupplementaryData($value);
        return $this;
    }

    /**
     * Sets payee field.
     */
    public function payee(?Payee $value): self
    {
        $this->instance->setPayee($value);
        return $this;
    }

    /**
     * Initializes a new captured payment object.
     */
    public function build(): CapturedPayment
    {
        return CoreHelper::clone($this->instance);
    }
}
