<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CardCustomerInformation;
use PaypalServerSdkLib\Models\PhoneWithType;

/**
 * Builder for model CardCustomerInformation
 *
 * @see CardCustomerInformation
 */
class CardCustomerInformationBuilder
{
    /**
     * @var CardCustomerInformation
     */
    private $instance;

    private function __construct(CardCustomerInformation $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new card customer information Builder object.
     */
    public static function init(): self
    {
        return new self(new CardCustomerInformation());
    }

    /**
     * Sets id field.
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets email address field.
     */
    public function emailAddress(?string $value): self
    {
        $this->instance->setEmailAddress($value);
        return $this;
    }

    /**
     * Sets phone field.
     */
    public function phone(?PhoneWithType $value): self
    {
        $this->instance->setPhone($value);
        return $this;
    }

    /**
     * Sets merchant customer id field.
     */
    public function merchantCustomerId(?string $value): self
    {
        $this->instance->setMerchantCustomerId($value);
        return $this;
    }

    /**
     * Initializes a new card customer information object.
     */
    public function build(): CardCustomerInformation
    {
        return CoreHelper::clone($this->instance);
    }
}
