<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\CardAttributes;
use PaypalServerSdkLib\Models\CardExperienceContext;
use PaypalServerSdkLib\Models\CardRequest;
use PaypalServerSdkLib\Models\CardStoredCredential;
use PaypalServerSdkLib\Models\NetworkToken;

/**
 * Builder for model CardRequest
 *
 * @see CardRequest
 */
class CardRequestBuilder
{
    /**
     * @var CardRequest
     */
    private $instance;

    private function __construct(CardRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new card request Builder object.
     */
    public static function init(): self
    {
        return new self(new CardRequest());
    }

    /**
     * Sets name field.
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets number field.
     */
    public function number(?string $value): self
    {
        $this->instance->setNumber($value);
        return $this;
    }

    /**
     * Sets expiry field.
     */
    public function expiry(?string $value): self
    {
        $this->instance->setExpiry($value);
        return $this;
    }

    /**
     * Sets security code field.
     */
    public function securityCode(?string $value): self
    {
        $this->instance->setSecurityCode($value);
        return $this;
    }

    /**
     * Sets billing address field.
     */
    public function billingAddress(?Address $value): self
    {
        $this->instance->setBillingAddress($value);
        return $this;
    }

    /**
     * Sets attributes field.
     */
    public function attributes(?CardAttributes $value): self
    {
        $this->instance->setAttributes($value);
        return $this;
    }

    /**
     * Sets vault id field.
     */
    public function vaultId(?string $value): self
    {
        $this->instance->setVaultId($value);
        return $this;
    }

    /**
     * Sets single use token field.
     */
    public function singleUseToken(?string $value): self
    {
        $this->instance->setSingleUseToken($value);
        return $this;
    }

    /**
     * Sets stored credential field.
     */
    public function storedCredential(?CardStoredCredential $value): self
    {
        $this->instance->setStoredCredential($value);
        return $this;
    }

    /**
     * Sets network token field.
     */
    public function networkToken(?NetworkToken $value): self
    {
        $this->instance->setNetworkToken($value);
        return $this;
    }

    /**
     * Sets experience context field.
     */
    public function experienceContext(?CardExperienceContext $value): self
    {
        $this->instance->setExperienceContext($value);
        return $this;
    }

    /**
     * Initializes a new card request object.
     */
    public function build(): CardRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
