<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\AuthenticationResponse;
use PaypalServerSdkLib\Models\BinDetails;
use PaypalServerSdkLib\Models\CardAttributesResponse;
use PaypalServerSdkLib\Models\CardFromRequest;
use PaypalServerSdkLib\Models\CardResponse;

/**
 * Builder for model CardResponse
 *
 * @see CardResponse
 */
class CardResponseBuilder
{
    /**
     * @var CardResponse
     */
    private $instance;

    private function __construct(CardResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new card response Builder object.
     */
    public static function init(): self
    {
        return new self(new CardResponse());
    }

    /**
     * Sets name field.
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets last digits field.
     */
    public function lastDigits(?string $value): self
    {
        $this->instance->setLastDigits($value);
        return $this;
    }

    /**
     * Sets brand field.
     */
    public function brand(?string $value): self
    {
        $this->instance->setBrand($value);
        return $this;
    }

    /**
     * Sets available networks field.
     */
    public function availableNetworks(?array $value): self
    {
        $this->instance->setAvailableNetworks($value);
        return $this;
    }

    /**
     * Sets type field.
     */
    public function type(?string $value): self
    {
        $this->instance->setType($value);
        return $this;
    }

    /**
     * Sets authentication result field.
     */
    public function authenticationResult(?AuthenticationResponse $value): self
    {
        $this->instance->setAuthenticationResult($value);
        return $this;
    }

    /**
     * Sets attributes field.
     */
    public function attributes(?CardAttributesResponse $value): self
    {
        $this->instance->setAttributes($value);
        return $this;
    }

    /**
     * Sets from request field.
     */
    public function fromRequest(?CardFromRequest $value): self
    {
        $this->instance->setFromRequest($value);
        return $this;
    }

    /**
     * Sets expiry field.
     */
    public function expiry(?string $value): self
    {
        $this->instance->setExpiry($value);
        return $this;
    }

    /**
     * Sets bin details field.
     */
    public function binDetails(?BinDetails $value): self
    {
        $this->instance->setBinDetails($value);
        return $this;
    }

    /**
     * Initializes a new card response object.
     */
    public function build(): CardResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
