<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CobrandedCard;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\PayeeBase;

/**
 * Builder for model CobrandedCard
 *
 * @see CobrandedCard
 */
class CobrandedCardBuilder
{
    /**
     * @var CobrandedCard
     */
    private $instance;

    private function __construct(CobrandedCard $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new cobranded card Builder object.
     */
    public static function init(): self
    {
        return new self(new CobrandedCard());
    }

    /**
     * Sets labels field.
     */
    public function labels(?array $value): self
    {
        $this->instance->setLabels($value);
        return $this;
    }

    /**
     * Sets payee field.
     */
    public function payee(?PayeeBase $value): self
    {
        $this->instance->setPayee($value);
        return $this;
    }

    /**
     * Sets amount field.
     */
    public function amount(?Money $value): self
    {
        $this->instance->setAmount($value);
        return $this;
    }

    /**
     * Initializes a new cobranded card object.
     */
    public function build(): CobrandedCard
    {
        return CoreHelper::clone($this->instance);
    }
}
