<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\NetworkTransactionReferenceEntity;

/**
 * Builder for model NetworkTransactionReferenceEntity
 *
 * @see NetworkTransactionReferenceEntity
 */
class NetworkTransactionReferenceEntityBuilder
{
    /**
     * @var NetworkTransactionReferenceEntity
     */
    private $instance;

    private function __construct(NetworkTransactionReferenceEntity $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new network transaction reference entity Builder object.
     */
    public static function init(string $id): self
    {
        return new self(new NetworkTransactionReferenceEntity($id));
    }

    /**
     * Sets date field.
     */
    public function date(?string $value): self
    {
        $this->instance->setDate($value);
        return $this;
    }

    /**
     * Sets network field.
     */
    public function network(?string $value): self
    {
        $this->instance->setNetwork($value);
        return $this;
    }

    /**
     * Sets time field.
     */
    public function time(?string $value): self
    {
        $this->instance->setTime($value);
        return $this;
    }

    /**
     * Initializes a new network transaction reference entity object.
     */
    public function build(): NetworkTransactionReferenceEntity
    {
        return CoreHelper::clone($this->instance);
    }
}
