<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PaymentInstruction;

/**
 * Builder for model PaymentInstruction
 *
 * @see PaymentInstruction
 */
class PaymentInstructionBuilder
{
    /**
     * @var PaymentInstruction
     */
    private $instance;

    private function __construct(PaymentInstruction $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new payment instruction Builder object.
     */
    public static function init(): self
    {
        return new self(new PaymentInstruction());
    }

    /**
     * Sets platform fees field.
     */
    public function platformFees(?array $value): self
    {
        $this->instance->setPlatformFees($value);
        return $this;
    }

    /**
     * Sets disbursement mode field.
     */
    public function disbursementMode(?string $value): self
    {
        $this->instance->setDisbursementMode($value);
        return $this;
    }

    /**
     * Sets payee pricing tier id field.
     */
    public function payeePricingTierId(?string $value): self
    {
        $this->instance->setPayeePricingTierId($value);
        return $this;
    }

    /**
     * Sets payee receivable fx rate id field.
     */
    public function payeeReceivableFxRateId(?string $value): self
    {
        $this->instance->setPayeeReceivableFxRateId($value);
        return $this;
    }

    /**
     * Initializes a new payment instruction object.
     */
    public function build(): PaymentInstruction
    {
        return CoreHelper::clone($this->instance);
    }
}
