<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use Core\Utils\CoreHelper;
use Exception;
use stdClass;

/**
 * The reason why the captured payment status is `PENDING` or `DENIED`.
 */
class CaptureIncompleteReason
{
    public const BUYER_COMPLAINT = 'BUYER_COMPLAINT';

    public const CHARGEBACK = 'CHARGEBACK';

    public const ECHECK = 'ECHECK';

    public const INTERNATIONAL_WITHDRAWAL = 'INTERNATIONAL_WITHDRAWAL';

    public const OTHER = 'OTHER';

    public const PENDING_REVIEW = 'PENDING_REVIEW';

    public const RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION = 'RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION';

    public const REFUNDED = 'REFUNDED';

    public const TRANSACTION_APPROVED_AWAITING_FUNDING = 'TRANSACTION_APPROVED_AWAITING_FUNDING';

    public const UNILATERAL = 'UNILATERAL';

    public const VERIFICATION_REQUIRED = 'VERIFICATION_REQUIRED';

    public const DECLINED_BY_RISK_FRAUD_FILTERS = 'DECLINED_BY_RISK_FRAUD_FILTERS';

    private const _ALL_VALUES = [
        self::BUYER_COMPLAINT,
        self::CHARGEBACK,
        self::ECHECK,
        self::INTERNATIONAL_WITHDRAWAL,
        self::OTHER,
        self::PENDING_REVIEW,
        self::RECEIVING_PREFERENCE_MANDATES_MANUAL_ACTION,
        self::REFUNDED,
        self::TRANSACTION_APPROVED_AWAITING_FUNDING,
        self::UNILATERAL,
        self::VERIFICATION_REQUIRED,
        self::DECLINED_BY_RISK_FRAUD_FILTERS
    ];

    /**
     * Ensures that all the given values are present in this Enum.
     *
     * @param array|stdClass|null|string $value Value or a list/map of values to be checked
     *
     * @return array|null|string Input value(s), if all are a part of this Enum
     *
     * @throws Exception Throws exception if any given value is not in this Enum
     */
    public static function checkValue($value)
    {
        $value = json_decode(json_encode($value), true); // converts stdClass into array
        if (CoreHelper::checkValueOrValuesInList($value, self::_ALL_VALUES)) {
            return $value;
        }
        throw new Exception("$value is invalid for CaptureIncompleteReason.");
    }
}
