<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * Minimal representation of a cached setup token.
 */
class SetupTokenResponse implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $id;

    /**
     * @var int|null
     */
    private $ordinal;

    /**
     * @var CustomerRequest|null
     */
    private $customer;

    /**
     * @var string|null
     */
    private $status = 'CREATED';

    /**
     * @var SetupTokenResponsePaymentSource|null
     */
    private $paymentSource;

    /**
     * @var LinkDescription[]|null
     */
    private $links;

    /**
     * Returns Id.
     * The PayPal-generated ID for the vault token.
     */
    public function getId(): ?string
    {
        return $this->id;
    }

    /**
     * Sets Id.
     * The PayPal-generated ID for the vault token.
     *
     * @maps id
     */
    public function setId(?string $id): void
    {
        $this->id = $id;
    }

    /**
     * Returns Ordinal.
     * Ordinal number for sorting.
     */
    public function getOrdinal(): ?int
    {
        return $this->ordinal;
    }

    /**
     * Sets Ordinal.
     * Ordinal number for sorting.
     *
     * @maps ordinal
     */
    public function setOrdinal(?int $ordinal): void
    {
        $this->ordinal = $ordinal;
    }

    /**
     * Returns Customer.
     * Customer in merchant's or partner's system of records.
     */
    public function getCustomer(): ?CustomerRequest
    {
        return $this->customer;
    }

    /**
     * Sets Customer.
     * Customer in merchant's or partner's system of records.
     *
     * @maps customer
     */
    public function setCustomer(?CustomerRequest $customer): void
    {
        $this->customer = $customer;
    }

    /**
     * Returns Status.
     * The status of the payment token.
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * Sets Status.
     * The status of the payment token.
     *
     * @maps status
     */
    public function setStatus(?string $status): void
    {
        $this->status = $status;
    }

    /**
     * Returns Payment Source.
     * The setup payment method details.
     */
    public function getPaymentSource(): ?SetupTokenResponsePaymentSource
    {
        return $this->paymentSource;
    }

    /**
     * Sets Payment Source.
     * The setup payment method details.
     *
     * @maps payment_source
     */
    public function setPaymentSource(?SetupTokenResponsePaymentSource $paymentSource): void
    {
        $this->paymentSource = $paymentSource;
    }

    /**
     * Returns Links.
     * An array of related [HATEOAS links](/api/rest/responses/#hateoas).
     *
     * @return LinkDescription[]|null
     */
    public function getLinks(): ?array
    {
        return $this->links;
    }

    /**
     * Sets Links.
     * An array of related [HATEOAS links](/api/rest/responses/#hateoas).
     *
     * @maps links
     *
     * @param LinkDescription[]|null $links
     */
    public function setLinks(?array $links): void
    {
        $this->links = $links;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->id)) {
            $json['id']             = $this->id;
        }
        if (isset($this->ordinal)) {
            $json['ordinal']        = $this->ordinal;
        }
        if (isset($this->customer)) {
            $json['customer']       = $this->customer;
        }
        if (isset($this->status)) {
            $json['status']         = $this->status;
        }
        if (isset($this->paymentSource)) {
            $json['payment_source'] = $this->paymentSource;
        }
        if (isset($this->links)) {
            $json['links']          = $this->links;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
